% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{oe_update}
\alias{oe_update}
\title{Update all the .osm.pbf files saved in a directory}
\usage{
oe_update(
  download_directory = oe_download_directory(),
  quiet = FALSE,
  delete_gpkg = TRUE,
  max_file_size = 5e+08,
  ...
)
}
\arguments{
\item{download_directory}{Character string of the path of the directory
where the \code{.osm.pbf} files are saved.}

\item{quiet}{Boolean. If \code{FALSE} the function prints informative
messages. See Details.}

\item{delete_gpkg}{Boolean. if \code{TRUE} the function deletes the old \code{.gpkg}
files. We added this parameter to minimize the probability of accidentally
reading-in old and not-synchronized \code{.gpkg} files. See Details. Defaults to
\code{TRUE}.}

\item{max_file_size}{The maximum file size to download without asking in
interactive mode. Default: \code{5e+8}, half a gigabyte.}

\item{...}{Additional parameter that will be passed to \code{\link[=oe_get]{oe_get()}} (such as
\code{stringsAsFactors} or \code{query}).}
}
\value{
The path(s) of the \code{.osm.pbf} file(s) that were updated.
}
\description{
This function is used to re-download all \code{.osm.pbf} files stored in
\code{download_directory} that were firstly downloaded through \code{\link[=oe_get]{oe_get()}}. See
Details.
}
\details{
This function is used to re-download \code{.osm.pbf} files that are
stored in a directory (specified by \code{download_directory} param) and that
were firstly downloaded through \code{\link[=oe_get]{oe_get()}} . The name of the files must
begin with the name of one of the supported providers (see
\code{\link[=oe_providers]{oe_providers()}}) and it must end with \code{.osm.pbf}. All other
files in the directory that do not match this format are ignored.

The process for re-downloading the \code{.osm.pbf} files is performed using the
function \code{\link[=oe_get]{oe_get()}} . The appropriate provider is determined by looking at
the first word in the path of the \code{.osm.pbf} file. The place is determined
by looking at the second word in the file path and the matching is
performed through the \code{id} column in the provider's database. So, for
example, the path \code{geofabrik_italy-latest-update.osm.pbf} will be matched
with the provider \code{"geofabrik"} and the geographical zone \code{italy} through
the column \code{id} in \code{geofabrik_zones}.

The parameter \code{delete_gpkg} is used to delete all \code{.gpkg} files in
\code{download_directory}. We decided to set its default value to \code{TRUE} to
minimize the possibility of reading-in old and non-synchronized \code{.gpkg}
files. If you set \code{delete_gpkg = FALSE}, then you need to manually
reconvert all files using \code{\link[=oe_get]{oe_get()}} or \code{\link[=oe_vectortranslate]{oe_vectortranslate()}} .

If you set the parameter \code{quiet} to \code{FALSE}, then the function will print
some useful messages regarding the characteristics of the files before and
after updating them. More precisely, it will print the output of the
columns \code{size}, \code{mtime} and \code{ctime} from \code{\link[=file.info]{file.info()}}. Please note that
the meaning of \code{mtime} and \code{ctime} depends on the OS and the file system.
Check \code{\link[=file.info]{file.info()}}.
}
\examples{
\dontrun{
# Set up a fake directory with .pbf and .gpkg files
fake_dir = tempdir()
# Fill the directory
oe_get("Andorra", download_directory = fake_dir, download_only = TRUE)
# Check the directory
list.files(fake_dir, pattern = "gpkg|pbf")
# Update all .pbf files and delete all .gpkg files
oe_update(fake_dir)
list.files(fake_dir, pattern = "gpkg|pbf")}
}
