% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_elements.R
\name{osm_delete_object}
\alias{osm_delete_object}
\title{Delete an OSM object}
\usage{
osm_delete_object(x, changeset_id)
}
\arguments{
\item{x}{The object data. Can be the path of an xml file, a \link[xml2:oldclass]{xml2::xml_document} or a data.frame inheriting
or following the structure of an \code{osmapi_objects} object.}

\item{changeset_id}{The ID of an open changeset where to create the object. If missing, \code{x} should define the
changeset ID, otherwise it will be overwritten with \code{changeset_id}. Ignored if \code{x} is a path.}
}
\value{
Returns the new version number of the object.
}
\description{
Expects a valid XML representation of the element to be deleted.
}
\details{
The version must match the version of the element you downloaded and the changeset must match the \code{id} of an open
changeset owned by the current authenticated user. It is allowed, but not necessary, to have tags on the element
except for lat/long which are required for nodes, without lat+lon the server gives 400 Bad request.

If \code{x} is a data.frame, the columns \code{type}, \code{id}, \code{version} and \code{changeset} must be present + \code{lat} and \code{lon} for
nodes. For the xml format, see the
\href{https://wiki.openstreetmap.org/wiki/API_v0.6#Delete:_DELETE_/api/0.6/\%5Bnode\%7Cway\%7Crelation\%5D/\%23id}{OSM wiki}.

If multiple elements are provided only the first is deleted. The rest is discarded.
}
\note{
\itemize{
\item This updates the bounding box of the changeset.
\item To avoid performance issues when deleting multiple objects, the use of the \code{\link[=osm_diff_upload_changeset]{osm_diff_upload_changeset()}} is highly
recommended. This is also the only way to ensure that multiple objects are updated in a single database
transaction.
}
}
\examples{
vignette("how_to_edit_osm", package = "osmapiR")
}
\seealso{
Other edit OSM objects' functions: 
\code{\link{osm_create_object}()},
\code{\link{osm_update_object}()}
}
\concept{edit OSM objects' functions}
