% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{oscar.cv}
\alias{oscar.cv}
\title{Cross-validation for oscar-fitted model objects over k-range}
\usage{
oscar.cv(
  fit,
  fold = 10,
  seed = NULL,
  strata = rep(1, times = nrow(fit@x)),
  verb = 0,
  ...
)
}
\arguments{
\item{fit}{oscar-model object}

\item{fold}{Number of cross-validation folds, Default: 10}

\item{seed}{Random seed for reproducibility with NULL indicating that it is not set, Default: NULL}

\item{strata}{Should stratified cross-validation be used; separate values indicate balanced strata. Default: Unit vector, which will treat all observations equally.}

\item{verb}{Level of verbosity with higher integer giving more information, Default: 0}

\item{...}{Additional parameters passed to oscar-function}
}
\value{
A matrix with goodness of fit over folds and k-values
}
\description{
Create a cross-validation matrix with the chosen goodness metric with n-folds. Based on the goodness metric, one ought to pick optimal cardinality (parameter 'k').
}
\details{
A k-fold cross-validation is run by mimicking the parameters contained in the original oscar S4-object. This requires the original data at slots @x and @y.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  fit_cv <- oscar.cv(fit, fold=10, seed=123)
  fit_cv
}
}
