% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthoDr_reg.r
\name{orthoDr_reg}
\alias{orthoDr_reg}
\title{Semiparametric dimension reduction method from Ma & Zhu (2012).}
\usage{
orthoDr_reg(
  x,
  y,
  method = "sir",
  ndr = 2,
  B.initial = NULL,
  bw = NULL,
  keep.data = FALSE,
  control = list(),
  maxitr = 500,
  verbose = FALSE,
  ncore = 0
)
}
\arguments{
\item{x}{A \code{matrix} or \code{data.frame} for features (continous only).
The algorithm will not scale the columns to unit variance}

\item{y}{A \code{vector} of continuous outcome}

\item{method}{Dimension reduction methods (semi-): \code{"sir"}, \code{"save"},
\code{"phd"}, \code{"local"} or \code{"seff"}. Currently only
\code{"sir"} and \code{"phd"} are available.}

\item{ndr}{The number of directions}

\item{B.initial}{Initial \code{B} values. If specified, must be a matrix with
\code{ncol(x)} rows and \code{ndr} columns. Will be processed by
Gram-Schmidt if not orthogonal. If the initial value is
not given, three initial values (\code{"sir"}, \code{"save"} and
\code{"phd"}) using the traditional method will be tested. The
one with smallest l2 norm of the estimating equation will
be used.}

\item{bw}{A Kernel bandwidth, assuming each variables have unit
variance}

\item{keep.data}{Should the original data be kept for prediction. Default
is \code{FALSE}.}

\item{control}{A list of tuning variables for optimization.
\code{epsilon} is the size for numerically approximating the
gradient. For others, see Wen and Yin (2013).}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}

\item{ncore}{Number of cores for parallel computing.
The default is the maximum number of threads.}
}
\value{
A \code{orthoDr} object consisting of \code{list} with named elements:

\item{B}{The optimal \code{B} value}
\item{fn}{The final functional value}
\item{itr}{The number of iterations}
\item{converge}{convergence code}
}
\description{
Performs the semiparametric dimension reduction method associated with
Ma & Zhu (2012).
}
\examples{
# generate some regression data
set.seed(1)
N <- 100
P <- 4
dataX <- matrix(rnorm(N * P), N, P)
Y <- -1 + dataX[, 1] + rnorm(N)

# fit the semi-sir model
orthoDr_reg(dataX, Y, ndr = 1, method = "sir")

# fit the semi-phd model
Y <- -1 + dataX[, 1]^2 + rnorm(N)
orthoDr_reg(dataX, Y, ndr = 1, method = "phd")
}
\references{
Ma, Y., & Zhu, L. (2012). A semiparametric approach to dimension reduction. Journal of the American Statistical Association, 107(497), 168-179.
DOI: \doi{10.1080/01621459.2011.646925}

Ma, Y., & Zhu, L. (2013). Efficient estimation in sufficient dimension reduction. Annals of statistics, 41(1), 250.
DOI: \doi{10.1214/12-AOS1072}
}
