% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthoDr_pdose.r
\name{orthoDr_pdose}
\alias{orthoDr_pdose}
\title{orthoDr_pdose model}
\usage{
orthoDr_pdose(x, a, r, ndr = ndr, B.initial = NULL, bw = NULL,
  lambda = 0.1, K = sqrt(length(r)), method = c("direct",
  "pseudo_direct"), keep.data = FALSE, control = list(),
  maxitr = 500, verbose = FALSE, ncore = 0)
}
\arguments{
\item{x}{A matrix or data.frame for features (continuous only).}

\item{a}{A vector of observed dose}

\item{r}{A vector of observed reward}

\item{ndr}{A dimension structure}

\item{B.initial}{Initial \code{B} values. Will use the counting process based SIR model \link[orthoDr]{CP_SIR} as the initial if leaving as \code{NULL}.
If specified, must be a matrix with \code{ncol(x)} rows and \code{ndr} columns. Will be processed by Gram-Schmidt if not orthogonal}

\item{bw}{A Kernel bandwidth, assuming each variables have unit variance}

\item{lambda}{The penalty level for kernel ridge regression. If a range of values is specified, the GCV will be used to select the best tuning}

\item{K}{A number of grids in the range of dose}

\item{method}{A method the user will implement}

\item{keep.data}{Should the original data be kept for prediction}

\item{control}{A list of tuning variables for optimization. \code{epsilon} is the size for numerically appriximating the gradient. For others, see Wen and Yin (2013).}

\item{maxitr}{Maximum number of iterations}

\item{verbose}{Should information be displayed}

\item{ncore}{the number of cores for parallel computing}
}
\value{
A \code{orthoDr} object; a list consisting of
\item{B}{The optimal \code{B} value}
\item{fn}{The final functional value}
\item{itr}{The number of iterations}
\item{converge}{convergence code}
}
\description{
The "Direct Learning & Pseudo-direct Learning" Method for personalized medicine.
}
\examples{
# generate some personalized dose scenario

exampleset <- function(size,ncov){

 X = matrix(runif(size*ncov,-1,1),ncol=ncov)
 A = runif(size,0,2)

 Edr =  as.matrix(c(0.5,-0.5))

 D_opt = X \%*\% Edr +1

 mu = 2 + 0.5*(X \%*\% Edr) - 7*abs(D_opt-A)

 R = rnorm(length(mu),mu,1)

 R = R - min(R)

 datainfo = list(X=X,A=A,R=R,D_opt=D_opt,mu=mu)
 return(datainfo)
}

# generate data

set.seed(123)
n = 150
p = 2
ndr =1
train = exampleset(n,p)
test = exampleset(500,p)

# the direct learning method
 orthofit = orthoDr_pdose(train$X,train$A,train$R,ndr = ndr,lambda = 0.1,
                       method = "direct", K = sqrt(n),keep.data = TRUE,
                       maxitr = 150,verbose = FALSE)

dose = predict(orthofit,test$X)

dosedistance = mean((test$D_opt-dose$pred)^2)
print(dosedistance)

# the pseudo direct learning method
orthofit = orthoDr_pdose(train$X,train$A,train$R,ndr = ndr,lambda = seq(0.1,0.2,0.01),
                      method = "pseudo_direct", K = sqrt(n),keep.data = TRUE,
                      maxitr = 150,verbose = FALSE)

dose = predict(orthofit,test$X)

# compare with the optimal dose

dosedistance = mean((test$D_opt-dose$pred)^2)
print(dosedistance)
}
\references{
Zhou, W., Zhu, R. "A Parsimonious Personalized Dose Model vis Dimension Reduction." (2018+)
\url{https://arxiv.org/abs/1802.06156}.

Wen, Z. and Yin, W., "A feasible method for optimization with orthogonality constraints." Mathematical Programming 142.1-2 (2013): 397-434.
DOI: \url{https://doi.org/10.1007/s10107-012-0584-1}
}
