% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magic.R, R/zzz_niftiImage.R
\docType{methods}
\name{magic-methods}
\alias{magic-methods}
\alias{magic-methods,}
\alias{magic}
\alias{magic,nifti-method}
\alias{magic<-}
\alias{magic<-,nifti-method}
\alias{magic,niftiImage-method}
\alias{magic<-,niftiImage-method}
\title{Extract Image Attribute \code{magic}}
\usage{
magic(object)

\S4method{magic}{nifti}(object)

magic(object) <- value

\S4method{magic}{nifti}(object) <- value

\S4method{magic}{niftiImage}(object)

\S4method{magic}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{magic} field.}
}
\description{
Methods that act on the \code{magic} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
magic(img)
magic(img) = "ni1"
stopifnot(magic(img) == "ni1")
magic(img) = "n+1"
stopifnot(magic(img) == "n+1")
magic(img) = "r" # bad magic
stopifnot(magic(img) == "")
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
