% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{print.margins.orf}
\alias{print.margins.orf}
\title{Print of the Ordered Forest Marginal Effects}
\usage{
\method{print}{margins.orf}(x, ...)
}
\arguments{
\item{x}{estimated Ordered Forest Marginal Effect object of type \code{margins.orf}}

\item{...}{further arguments (currently ignored)}
}
\description{
print of estimated marginal effects of the Ordered Forest of class \code{margins.orf}
}
\details{
\code{print.margins.orf} provides a first glimpse of the Ordered Forest
marginal effects, printed directly to the \code{R} console. The printed information
contains the results for the marginal effects for each covariate and each outcome class.
}
\examples{
## Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates
Y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

# estimate Ordered Forest
orf_fit <- orf(X, Y)
\donttest{
# estimate marginal effects of the orf
orf_margins <- margins(orf_fit)

# print marginal effects
print(orf_margins)
}

}
\author{
Gabriel Okasa
}
