% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-negation.r
\name{negation}
\alias{negation}
\alias{get_negation}
\alias{revert_negation}
\alias{negate_ord}
\alias{negate_to_first_orthant}
\title{Negation of ordination axes}
\usage{
get_negation(x)

revert_negation(x)

negate_ord(x, negation = NULL)

negate_to_first_orthant(x, .matrix)
}
\arguments{
\item{x}{A \link{tbl_ord}.}

\item{negation}{Integer vector of coordinates to negate.}

\item{.matrix}{A character string partially matched (lowercase) to several
indicators for one or both matrices in a matrix decomposition used for
ordination. The standard values are \code{"rows"}, \code{"cols"}, and \code{"dims"} (for
both).}
}
\value{
\code{negate_ord()} and \code{negate_to_first_orthant()} return a tbl_ord with
certain axes negated but the wrapped model unchanged. \code{get_negation()}
returns the current negations. \code{revert_negation()} returns the tbl_ord
without any manual negations.

A tbl_ord; the wrapped model is unchanged.
}
\description{
Negate the coordinates of a subset of ordination axes in both
row and column singular vectors.
}
\details{
For purposes of comparison and visualization, it can be useful to negate the
(already artificial) coordinates of an ordination, either by fixed criteria
or to better align with another basis (matrix) of coordinates. \code{negate_ord()}
allows the user to negate specified coordinates of an ordination.

\code{get_negation()} accesses the negations of an ordination, an integer vector
of \code{1}s and \code{-1}s stored as a \code{"negate"} attribute.
}
\examples{
(pca <- ordinate(iris, cols = 1:4, prcomp))
ggbiplot(pca) + geom_rows_point() + geom_cols_vector()

# manually negate second coordinate
(pca_neg <- negate_ord(pca, 2))
ggbiplot(pca_neg) + geom_rows_point() + geom_cols_vector()

# NB: 'prcomp' method takes precedence; negations are part of the wrapper
biplot(pca)
biplot(pca_neg)

# negate to the first orthant
(pca_orth <- negate_to_first_orthant(pca, "v"))
get_negation(pca_orth)
}
