% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-stats-kmeans.r
\name{methods-kmeans}
\alias{methods-kmeans}
\alias{as_tbl_ord.kmeans}
\alias{recover_rows.kmeans}
\alias{recover_cols.kmeans}
\alias{recover_coord.kmeans}
\alias{recover_aug_rows.kmeans}
\alias{recover_aug_cols.kmeans}
\alias{recover_aug_coord.kmeans}
\title{Functionality for k-means clustering ('kmeans') objects}
\usage{
\method{as_tbl_ord}{kmeans}(x)

\method{recover_rows}{kmeans}(x)

\method{recover_cols}{kmeans}(x)

\method{recover_coord}{kmeans}(x)

\method{recover_aug_rows}{kmeans}(x)

\method{recover_aug_cols}{kmeans}(x)

\method{recover_aug_coord}{kmeans}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"kmeans"} as returned by \code{\link[stats:kmeans]{stats::kmeans()}}.
}
\examples{
# data frame of Anderson iris species measurements
class(iris)
head(iris)
# compute 3-means clustering on scaled iris measurements
set.seed(5601L)
iris \%>\%
  subset(select = -Species) \%>\%
  scale() \%>\%
  kmeans(centers = 3) \%>\%
  print() -> iris_km

# visualize clusters using PCA
iris \%>\%
  subset(select = -Species) \%>\%
  prcomp() \%>\%
  as_tbl_ord() \%>\%
  mutate_rows(cluster = iris_km$cluster) \%>\%
  ggbiplot() +
  geom_rows_point(aes(color = factor(as.character(as.integer(cluster)),
                                     levels = as.character(seq(3L))))) +
  scale_color_brewer(type = "qual", name = "cluster")

# wrap as a 'tbl_ord' object
(iris_km_ord <- as_tbl_ord(iris_km))

# augment everything with names, observations with cluster assignment
(iris_km_ord <- augment_ord(iris_km_ord))

# summarize clusters with standard deviation
iris_km_ord \%>\%
  tidy() \%>\%
  transform(sdev = sqrt(withinss / size))

# discriminate between clusters 2 and 3
iris_km_ord \%>\%
  ggbiplot(aes(x = `2`, y = `3`), color = factor(.cluster)) +
  geom_jitter(stat = "rows", aes(shape = cluster), width = .2, height = .2) +
  geom_cols_axis(aes(color = `1`, label = name),
                 text_size = 2, text_dodge = .1,
                 label_size = 3, label_alpha = .5) +
  scale_x_continuous(expand = expansion(mult = .8)) +
  scale_y_continuous(expand = expansion(mult = .5)) +
  ggtitle(
    "Measurement loadings onto clusters 2 and 3",
    "Color indicates loadings onto cluster 1"
  )
}
\seealso{
Other methods for idiosyncratic techniques: 
\code{\link{methods-lm}}
}
\concept{methods for idiosyncratic techniques}
