% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.methods.R
\name{extractAIC.ocmm}
\alias{extractAIC.ocmm}
\title{Extract AIC from a fitted Continuous Ordinal Mixed Model}
\usage{
\method{extractAIC}{ocmm}(fit, scale = 0, k = 2, ...)
}
\arguments{
\item{fit}{\code{ocmm} object}

\item{scale}{parameter currently not used. For compatibility with general extractAIC method.}

\item{k}{`weight' of the equivalent degrees of freedom (=: edf)
in the AIC formula. Defaults to 2.}

\item{...}{further arguments (currently unused)}
}
\value{
A numeric vector of length 2, with first and second elements giving
\item{edf}{the ``equivalent degrees of freedom'' for the fitted model \code{fit}}
\item{AIC}{the generalized AIC of \code{ocmm} object \code{fit}}
}
\description{
Extracts the AIC for a fitted \code{ocmm} object
}
\details{
The generalized AIC is computed:
\deqn{-2\ell +k\cdot edf}
where \eqn{\ell} is the log likelihood, k=2 gives the AIC, and
k=log(n) gives the BIC.
}
\examples{
\dontrun{
fit.overall.rnd  <- ocmm(overall  ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
extractAIC(fit.overall.rnd)
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\references{
Akaike, H (1983).
Information measures and model selection,
\emph{Bulletin of the International Statistical Institute}, 50:277-290.
}
\seealso{
\code{\link{ocmm}}, \code{\link{extractAIC.ocm}}
}

