% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.R
\name{to_r_fun}
\alias{to_r_fun}
\title{Turn orbital object into a R function}
\usage{
to_r_fun(x, name = "orbital_predict", file)
}
\arguments{
\item{x}{A orbital object.}

\item{name}{Name of created function. Defaults to `"orbital_predict"``.}

\item{file}{A file name.}
}
\value{
A orbital object.
}
\description{
Turn orbital object into a R function
}
\examples{
\dontshow{if (rlang::is_installed(c("recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

file_name <- tempfile()

to_r_fun(orbital_obj, file = file_name)

readLines(file_name)
\dontshow{\}) # examplesIf}
}
