% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{orbital_sql}
\alias{orbital_sql}
\title{Convert to SQL code}
\usage{
orbital_sql(x, con)
}
\arguments{
\item{x}{A orbital object.}

\item{con}{A connection object.}
}
\value{
SQL code.
}
\description{
Convert to SQL code
}
\examples{
\dontshow{if (rlang::is_installed(c("dbplyr", "recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

library(dbplyr)
con <- simulate_dbi()

orbital_sql(orbital_obj, con)
\dontshow{\}) # examplesIf}
}
