% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mort_funs.R
\name{mort_funs}
\alias{mort_funs}
\alias{exp_mort}
\alias{decreasing_mort}
\alias{constant_mort}
\alias{inv_mort}
\alias{gaussian_mort}
\alias{half_gaussian_mort}
\alias{linear_mort}
\alias{parabolic_mort}
\title{Functions to produce mortality curves}
\usage{
exp_mort(time, m_init, m_inf, alpha, t_scale = NULL)

decreasing_mort(time, m_init, m_inf, alpha)

constant_mort(time, m_init)

inv_mort(time, m_init, m_inf)

gaussian_mort(time, m_init, m_max, t_scale, alpha)

half_gaussian_mort(time, m_init, m_max, m_inf, t_scale, alpha)

linear_mort(time, alpha, m_init)

parabolic_mort(time, m_min, alpha, t_scale, beta)
}
\arguments{
\item{time}{The time to calculate mortality at}

\item{m_init}{Initial rate of mortality at time 0 (or time t for
\code{constant_mort})}

\item{m_inf}{Final rate of mortality as time approaches infinity}

\item{alpha}{The rate at which mortality decreases across time}

\item{t_scale}{A horizontal scaling parameter}

\item{m_max}{The maximum mortality that is achieved at \code{time = t_scale}}

\item{m_min}{The lowest mortality that the curve should reach}

\item{beta}{Slope on the quadratic term for \code{parabolic_mort}}
}
\value{
A vector of numeric values for mortality rate at \code{time}
}
\description{
This family of functions produce different shapes of mortality curves across
time
}
\details{
These functions produced different shapes of mortality curves that are
commonly found in fisheries. Some of the more common are
\code{constant_mort} (which returns constant mortality across time),
\code{exp_mort} (S-shaped decreasing curve), and \code{decreasing_mort}
(non-linear decreasing curve). Others are less common and represent specific
scenarios such as \code{gaussian_mort} (implemented to represent a
bottleneck).
}
\examples{
# an example in years
curve(exp_mort(x, 0.2, 0.1, 0.25), 0, 20)
# an example in days
curve(exp_mort(x, (1 / 365), (0.2 / 365), 0.005), 0, 1000)
}
