% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPsi.R
\name{getPsi}
\alias{getPsi}
\title{Calculate Psi, the Inverse of Nu Prime}
\usage{
getPsi(nuPrime, conditionalPower)
}
\arguments{
\item{nuPrime}{The function value to be inverted.}

\item{conditionalPower}{The target conditional power \eqn{CP} of the design. Must be a numeric value.}
}
\value{
The value of alpha which corresponds to nuPrime and lies between 0 and \code{conditionalPower}.
}
\description{
Get point-wise values of psi (inverse of nu prime)
}
\details{
The function \eqn{\psi} is the inverse of:
\deqn{\nu'(\alpha) = -2 \cdot(\Phi^{-1}(1-\alpha) + \Phi^{-1}(1-CP)) / \phi(\Phi^{-1}(1-\alpha))}.
If the conditional power \eqn{CP} lies outside of the range \eqn{1-\Phi(2) \leq CP \leq \Phi(2)}, the calculation is slightly more complicated.
The argument \code{conditionalPower} is either the fixed target conditional power or the value of the conditional power function at the corresponding first-stage p-value.
}
\examples{
# Returns 0.05
getPsi(getNuPrime(alpha = 0.05, conditionalPower = 0.9), conditionalPower = 0.9)
}
