% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-mixture.R
\name{predict.mixture}
\alias{predict.mixture}
\title{Predict method for Mixture models}
\usage{
\method{predict}{mixture}(
  object,
  newexperts = NULL,
  newY = NULL,
  awake = NULL,
  online = TRUE,
  type = c("model", "response", "weights", "all"),
  use_cpp = getOption("opera_use_cpp", default = FALSE),
  quiet = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of class inheriting from 'mixture'}

\item{newexperts}{An optional matrix in which to look for expert advice with which
predict. If omitted, the past predictions of the object are returned and the
object is not updated.}

\item{newY}{An optional matrix with d columns (or vector if \eqn{d=1}) of observations to be predicted. If provided, it 
should have the same number of rows as the number of rows of \code{newexperts}.
If omitted, the object (i.e, the aggregation rule) is not updated.}

\item{awake}{An optional array specifying the
activation coefficients of the experts. It must have the same dimension as experts. Its entries lie in \code{[0,1]}.
Possible if some experts are specialists and do not always form and suggest
prediction. If the expert number \code{k} at instance \code{t} does not
form any prediction of observation \code{Y_t}, we can put
\code{awake[t,k]=0} so that the mixture does not consider expert \code{k} in
the mixture to predict \code{Y_t}.}

\item{online}{A boolean determining if the observations in newY are predicted
sequentially (by updating the object step by step) or not. If FALSE, 
the observations are predicting using the object (without using any past 
information in newY). If TRUE, newY and newexperts should not be null.}

\item{type}{Type of prediction. It can be 
\describe{
   \item{model}{return the updated version of object (using newY and newexperts).}
   \item{response}{return the forecasts. If type is 'model', forecasts can also 
   be obtained from the last values of object$prediction.}
   \item{weights}{return the weights assigned to the expert advice to 
   produce the forecasts. If type is 'model', forecasts can also 
   be obtained from the last rows of object$weights.}
   \item{all}{return a list containing 'model', 'response', and 'weights'.}
   }}

\item{use_cpp}{\code{boolean}. Whether or not to use cpp optimization to fasten the computations. This option is not yet compatible
with the use of custom loss function.}

\item{quiet}{\code{boolean}. Whether or not to display progress bars.}

\item{...}{further arguments are ignored}
}
\value{
\code{predict.mixture} produces a matrix of predictions 
(type = 'response'), an updated object (type = 'model'), or a matrix of
weights (type = 'weights').
}
\description{
Performs sequential predictions and updates
of a mixture object based on new observations 
and expert advice.
}
