% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_numfmt}
\alias{wb_add_numfmt}
\title{Modify number formatting in a cell region}
\usage{
wb_add_numfmt(wb, sheet = current_sheet(), dims = "A1", numfmt)
}
\arguments{
\item{wb}{A Workbook}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{numfmt}{either an id or a character}
}
\value{
The \code{wbWorkbook} object, invisibly.
}
\description{
Add number formatting to a cell region. You can use a number format created
by \code{\link[=create_numfmt]{create_numfmt()}}.
}
\examples{
 wb <- wb_workbook() \%>\% wb_add_worksheet("S1") \%>\% wb_add_data("S1", mtcars)
 wb \%>\% wb_add_numfmt("S1", dims = "F1:F33", numfmt = "#.0")
}
\seealso{
\code{\link[=create_numfmt]{create_numfmt()}}

Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_cell_style}}
}
\concept{styles}
