% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_data}
\alias{write_data}
\title{Write an object to a worksheet}
\usage{
write_data(
  wb,
  sheet,
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  col_names = TRUE,
  row_names = FALSE,
  with_filter = FALSE,
  sep = ", ",
  name = NULL,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{Object to be written. For classes supported look at the examples.}

\item{dims}{Spreadsheet dimensions that will determine startCol and startRow: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write to.}

\item{start_row}{A vector specifying the starting row to write to.}

\item{array}{A bool if the function written is of type array}

\item{col_names}{If \code{TRUE}, column names of x are written.}

\item{row_names}{If \code{TRUE}, data.frame row names of x are written.}

\item{with_filter}{If \code{TRUE}, add filters to the column name row. NOTE can only have one filter per worksheet.}

\item{sep}{Only applies to list columns. The separator used to collapse list columns to a character vector e.g. sapply(x$list_column, paste, collapse = sep).}

\item{name}{If not NULL, a named region is defined.}

\item{apply_cell_style}{apply styles when writing on the sheet}

\item{remove_cell_style}{if writing into existing cells, should the cell style be removed?}

\item{na.strings}{Value used for replacing \code{NA} values from \code{x}. Default
\code{na_strings()} uses the special \verb{#N/A} value within the workbook.}

\item{inline_strings}{write characters as inline strings}

\item{...}{additional arguments}
}
\value{
invisible(0)
}
\description{
Write an object to worksheet with optional styling. Use \code{\link[=wb_add_data]{wb_add_data()}} in new code.
}
\details{
Formulae written using write_formula to a Workbook object will not get picked up by read_xlsx().
This is because only the formula is written and left to Excel to evaluate the formula when the file is opened in Excel.
The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}. If the data frame contains this string, the output will be broken.
}
\examples{
## See formatting vignette for further examples.

## Options for default styling (These are the defaults)
options("openxlsx2.dateFormat" = "mm/dd/yyyy")
options("openxlsx2.datetimeFormat" = "yyyy-mm-dd hh:mm:ss")
options("openxlsx2.numFmt" = NULL)

#############################################################################
## Create Workbook object and add worksheets
wb <- wb_workbook()

## Add worksheets
wb$add_worksheet("Cars")
wb$add_worksheet("Formula")

x <- mtcars[1:6, ]
wb$add_data("Cars", x, startCol = 2, startRow = 3, rowNames = TRUE)

#############################################################################
## Hyperlinks
## - vectors/columns with class 'hyperlink' are written as hyperlinks'

v <- rep("https://CRAN.R-project.org/", 4)
names(v) <- paste0("Hyperlink", 1:4) # Optional: names will be used as display text
class(v) <- "hyperlink"
wb$add_data("Cars", x = v, dims = c("B32"))

#############################################################################
## Formulas
## - vectors/columns with class 'formula' are written as formulas'

df <- data.frame(
  x = 1:3, y = 1:3,
  z = paste(paste0("A", 1:3 + 1L), paste0("B", 1:3 + 1L), sep = "+"),
  stringsAsFactors = FALSE
)

class(df$z) <- c(class(df$z), "formula")

wb$add_data(sheet = "Formula", x = df)

#############################################################################
# update cell range and add mtcars
xlsxFile <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
wb2 <- wb_load(xlsxFile)

# read dataset with inlinestr
wb_to_df(wb2)
write_data(wb2, 1, mtcars, startCol = 4, startRow = 4)
wb_to_df(wb2)
}
\seealso{
\code{\link[=wb_add_data]{wb_add_data()}}, \code{\link[=wb_add_data_table]{wb_add_data_table()}}
}
\keyword{internal}
