% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{named_region}
\alias{named_region}
\alias{wb_add_named_region}
\alias{wb_remove_named_region}
\title{Create / delete a named region}
\usage{
wb_add_named_region(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  name,
  local_sheet = FALSE,
  overwrite = FALSE,
  comment = NULL,
  custom_menu = NULL,
  description = NULL,
  is_function = NULL,
  function_group_id = NULL,
  help = NULL,
  hidden = NULL,
  local_name = NULL,
  publish_to_server = NULL,
  status_bar = NULL,
  vb_procedure = NULL,
  workbook_parameter = NULL,
  xml = NULL,
  ...
)

wb_remove_named_region(wb, sheet = current_sheet(), name = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{dims}{Worksheet dimension, single cell ("A1") or cell range ("A1:D4")}

\item{name}{Name for region. A character vector of length 1. Note region names musts be case-insensitive unique.}

\item{local_sheet}{If \code{TRUE} the named region will be local for this sheet}

\item{overwrite}{Boolean. Overwrite if exists? Default to FALSE}

\item{comment}{description text for named region}

\item{custom_menu}{customMenu (unknown xml feature)}

\item{description}{description (unknown xml feature)}

\item{is_function}{function (unknown xml feature)}

\item{function_group_id}{function group id (unknown xml feature)}

\item{help}{help (unknown xml feature)}

\item{hidden}{hidden if the named region should be hidden}

\item{local_name}{localName (unknown xml feature)}

\item{publish_to_server}{publish to server (unknown xml feature)}

\item{status_bar}{status bar (unknown xml feature)}

\item{vb_procedure}{wbProcedure (unknown xml feature)}

\item{workbook_parameter}{workbookParameter (unknown xml feature)}

\item{xml}{xml (unknown xml feature)}

\item{...}{additional arguments}
}
\description{
Create / delete a named region
}
\details{
Region is given by: min(cols):max(cols) X min(rows):max(rows)
}
\examples{
## create named regions
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")

## specify region
wb$add_data(sheet = 1, x = iris, startCol = 1, startRow = 1)
wb$add_named_region(
  sheet = 1,
  name = "iris",
  dims = wb_dims(
    rows = seq_len(nrow(iris) + 1),
    cols = seq_along(iris)
  )
)


## using write_data 'name' argument
wb$add_data(sheet = 1, x = iris, name = "iris2", startCol = 10)

out_file <- temp_xlsx()
wb_save(wb, out_file, overwrite = TRUE)

## see named regions
wb_get_named_regions(wb) ## From Workbook object
wb_get_named_regions(out_file) ## From xlsx file

## delete one
wb$remove_named_region(name = "iris2")
wb_get_named_regions(wb)

## read named regions
df <- read_xlsx(wb, namedRegion = "iris")
head(df)

df <- read_xlsx(out_file, namedRegion = "iris2")
head(df)
}
