% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWorkbook.R
\name{wb_read}
\alias{wb_read}
\title{Read from an Excel file or Workbook object}
\usage{
wb_read(
  xlsxFile,
  sheet = 1,
  startRow = 1,
  startCol = NULL,
  rowNames = FALSE,
  colNames = TRUE,
  skipEmptyRows = FALSE,
  skipEmptyCols = FALSE,
  rows = NULL,
  cols = NULL,
  detectDates = TRUE,
  namedRegion,
  na.strings = "NA",
  na.numbers = NA
)
}
\arguments{
\item{xlsxFile}{An xlsx file, Workbook object or URL to xlsx file.}

\item{sheet}{The name or index of the sheet to read data from.}

\item{startRow}{first row to begin looking for data.}

\item{startCol}{first column to begin looking for data.}

\item{rowNames}{If \code{TRUE}, first column of data will be used as row names.}

\item{colNames}{If \code{TRUE}, the first row of data will be used as column names.}

\item{skipEmptyRows}{If \code{TRUE}, empty rows are skipped else empty rows after the first row containing data
will return a row of NAs.}

\item{skipEmptyCols}{If \code{TRUE}, empty columns are skipped.}

\item{rows}{A numeric vector specifying which rows in the Excel file to read.
If NULL, all rows are read.}

\item{cols}{A numeric vector specifying which columns in the Excel file to read.
If NULL, all columns are read.}

\item{detectDates}{If \code{TRUE}, attempt to recognize dates and perform conversion.}

\item{namedRegion}{A named region in the Workbook. If not NULL startRow, rows and cols parameters are ignored.}

\item{na.strings}{A character vector of strings which are to be interpreted as NA. Blank cells will be returned as NA.}

\item{na.numbers}{A numeric vector of digits which are to be interpreted as NA. Blank cells will be returned as NA.}
}
\value{
data.frame
}
\description{
Read data from an Excel file or Workbook object into a data.frame
}
\details{
Creates a data.frame of all data in worksheet.
}
\examples{
xlsxFile <- system.file("extdata", "readTest.xlsx", package = "openxlsx2")
df1 <- wb_read(xlsxFile = xlsxFile, sheet = 1)

xlsxFile <- system.file("extdata", "readTest.xlsx", package = "openxlsx2")
df1 <- wb_read(xlsxFile = xlsxFile, sheet = 1, rows = c(1, 3, 5), cols = 1:3)
}
\seealso{
\code{\link[=get_named_regions]{get_named_regions()}}

\code{\link[=read_xlsx]{read_xlsx()}}
}
