\name{dlsegments}
\alias{dlsegments}
\title{Create a Double Line Segment Plot}
\description{Creae a plot showing two line segments. The union or intersection of those line segments can also be generated by utilizing the \code{type} argument.}
\usage{
dlsegments(x1 = c(3, 7), x2 = c(5, 9), l = c("o", "o"), r = c("c", "c"),
           type = c("n", "u", "i"), COL = 2, lwd = 2.224, ylim = c(-0.35, 2),
           mar = rep(0, 4), hideOrig = FALSE)
}
\arguments{
  \item{x1}{ The endpoints of the first interval. Values larger (smaller) than 999 (-999) will be interpreted as (negative) infinity. }
  \item{x2}{ The endpoints of the second interval. Values larger (smaller) than 999 (-999) will be interpreted as (negative) infinity. }
  \item{l}{ A vector of length 2, where the values correspond to the left end point of each interval. A value of \code{"o"} indicates the interval is open at the left and \code{"c"} indicates the interval is closed at this end. }
  \item{r}{ A vector of length 2, where the values correspond to the right end point of each interval. A value of \code{"o"} indicates the interval is open at the right and \code{"c"} indicates the interval is closed at this end. }
  \item{type}{ By default, no intersection or union of the two lines will be shown (value of \code{"n"}). To show the union of the line segments, specify \code{"u"}. To indicate that the intersection be shown, specify \code{"i"}. }
  \item{COL}{ If the union or intersection is to be shown (see the \code{type} argument), then this parameter controls the color that will be shown. }
  \item{lwd}{ If the union or intersection is to be shown (see the \code{type} argument), then this parameter controls the width of any corresponding lines or open points in the union or intersection. }
  \item{ylim}{ A vector of length 2 specifying the vertical plotting limits, which may be useful for fine-tuning plots. The default is \code{c(-0.35,2)}. }
  \item{mar}{ A vector of length 4 that represent the plotting margins. }
  \item{hideOrig}{ An optional argument that to specify that the two line segments should be shown (\code{hideOrig} takes value \code{FALSE}, the default) or that they should be hidden (\code{hideOrig} takes value \code{TRUE}. }
}
\references{ OpenIntro, \href{http://www.openintro.org/alge}{openintro.org} }
\author{ David Diez }
\seealso{ \code{\link{lsegments}}, \code{\link{CCP}}, \code{\link{ArrowLines}} }
\examples{
dlsegments(c(-3,3), c(1, 1000),
           r=c("o", "o"), l=c("c", "o"), COL=COL[4])

dlsegments(c(-3,3), c(1, 1000),
           r=c("o", "o"), l=c("c", "o"), type="un", COL=COL[4])

dlsegments(c(-3,3), c(1, 1000),
           r=c("o", "o"), l=c("c", "o"), type="in", COL=COL[4])
}
\keyword{ Line Segment }
\keyword{ Algebra }
