% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{og_create}
\alias{og_create}
\title{Create Open Graph meta tags}
\usage{
og_create(title, type, image, url, ...)
}
\arguments{
\item{title}{The title of your object as it should appear within the graph}

\item{type}{The type of your object, e.g., "video.movie". Depending on the type you specify, other properties may also be required.}

\item{image}{An image URL which should represent your object within the graph.}

\item{url}{The canonical URL of your object that will be used as its permanent ID in the graph}

\item{...}{Additional Open Graph properties}
}
\value{
A character vector of Open Graph meta tags
}
\description{
Create Open Graph meta tags
}
\examples{
og_create(
  title = 'Process the Open Graph Protocol',
  type = 'website',
  image = 'http://christophertkenny.com/opengraph/logo.png',
  url = 'https://christophertkenny.com/opengraph/',
  description = 'Parse metadata on websites which use the Open Graph Protocol.'
)
}
