% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{AnyOf}
\alias{AnyOf}
\title{AnyOf}
\value{
Object of \code{\link[=R6Class]{R6Class()}} representing an argument choice object.
}
\description{
Inheriting from \code{\link[=Argument]{Argument()}} in order to represent an argument choice object. Multiple
types can be stated, but at least one data type has to be picked. In a JSON-schema this is often used to make
objects nullable - meaning that they allow NULL as value. The AnyOf parameter is resolved into a simple nullable argument
if this applies.
}
\section{Methods}{

\describe{
\item{\verb{$getChoice()}}{returns a list of \code{\link[=Argument]{Argument()}} that are allowed}
\item{\verb{$isNullable}}{returns TRUE if only one element is in the choice that is not "null"}
}
}

\seealso{
\code{\link[=Array]{Array()}}, \code{\link[=Integer]{Integer()}}, \code{\link[=EPSGCode]{EPSGCode()}}, \code{\link[=String]{String()}}, \code{\link[=Number]{Number()}},
\code{\link[=Date]{Date()}}, \code{\link[=RasterCube]{RasterCube()}}, \code{\link[=VectorCube]{VectorCube()}}, \code{\link[=ProcessGraphArgument]{ProcessGraphArgument()}},
\code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}}, \code{\link[=OutputFormatOptions]{OutputFormatOptions()}}, \code{\link[=GeoJson]{GeoJson()}},
\code{\link[=Boolean]{Boolean()}}, \code{\link[=DateTime]{DateTime()}}, \code{\link[=Time]{Time()}}, \code{\link[=BoundingBox]{BoundingBox()}}, \code{\link[=Kernel]{Kernel()}},
\code{\link[=TemporalInterval]{TemporalInterval()}}, \code{\link[=TemporalIntervals]{TemporalIntervals()}}, \code{\link[=CollectionId]{CollectionId()}}, \code{\link[=OutputFormat]{OutputFormat()}},
\code{\link[=AnyOf]{AnyOf()}}, \code{\link[=ProjDefinition]{ProjDefinition()}}, \code{\link[=UdfCodeArgument]{UdfCodeArgument()}}, \code{\link[=UdfRuntimeArgument]{UdfRuntimeArgument()}} and
\code{\link[=UdfRuntimeVersionArgument]{UdfRuntimeVersionArgument()}},\code{\link[=TemporalIntervals]{TemporalIntervals()}}, \code{\link[=MetadataFilter]{MetadataFilter()}}
}
