% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udf.R
\name{send_udf}
\alias{send_udf}
\title{Test a UDF operation}
\usage{
send_udf(
  data,
  code,
  host = "http://localhost",
  port = NULL,
  language = "R",
  debug = FALSE,
  user_context = NA,
  server_context = NA,
  download_info = FALSE,
  legacy = FALSE,
  ...
)
}
\arguments{
\item{data}{file path or a list object with the UDF-API data object}

\item{code}{a call object or a file path of the user defined code}

\item{host}{URL to the UDF service}

\item{port}{(optional) port of the UDF service host}

\item{language}{programming language (R or Python) of the source code}

\item{debug}{(optional) logical - Switch on / off debugging information}

\item{user_context}{list - Context parameter that are shipped from the user into the udf_service}

\item{server_context}{list - Context usually sent from the back-end to trigger certain settings}

\item{download_info}{(optional) logical - Whether or not to print the time taken separately for 
the download}

\item{legacy}{logical - Whether or not the legacy endpoint is used (default: FALSE)}

\item{...}{parameters passed on to httr::content or to be more precise to jsonlite::fromJSON}
}
\value{
the textual JSON representation of the result
}
\description{
This function is still under development and depends heavily on test data in a specific format and whether or not the back-end provider
exposes their UDF service endpoint or if you have setup a local UDF service (see notes). The openEO UDF API v0.1.0 had foreseen to ship
data and code in a single message and to be interpretable by a computing service a specific format was designed. Usually this whole operation
is neatly hidden within the back-end, but if you want to test and debug the code, you need to create such data first. Some examples are available
at \url{https://github.com/Open-EO/openeo-r-udf/tree/master/examples/data}.
}
\details{
Hint: If you use a local R UDF service you might want to debug using the 'browser()' function.
}
\note{
The debug options are only available for the R-UDF service. The R UDF-API version has to be of version 0.1.0 (not the old alpha 
version). You might want to check \url{https://github.com/Open-EO/openeo-r-udf#running-the-api-locally} for setting up a local 
service for debugging.
}
\examples{
\dontrun{
port = 5555
host = "http://localhost" 
script = quote({
  all_dim = names(dim(data))
  ndvi_result = st_apply(data, FUN = function(X,...) {
    (X[8]-X[4])/(X[8]+X[4])
  }, MARGIN = all_dim[-which(all_dim=="band")])

  all_dim = names(dim(ndvi_result))
  min_ndvi = st_apply(ndvi_result,FUN = min, MARGIN = all_dim[-which(all_dim=="t")])

  min_ndvi
})
result = send_udf(data = "hypercube.json",code = script,host=host,port=port)

}
}
