% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{compute_result}
\alias{compute_result}
\title{Executes a job and returns the data immediately}
\usage{
compute_result(
  graph,
  output_file = NULL,
  budget = NULL,
  plan = NULL,
  con = NULL,
  ...
)
}
\arguments{
\item{graph}{a \code{\link{Graph}}, a function returning a \code{\link{ProcessNode}} as an endpoint or the \code{\link{ProcessNode}} 
will return the results}

\item{output_file}{storage location for the returned data}

\item{budget}{numeric, maximum spendable amount for testing}

\item{plan}{character, selection of a service plan}

\item{con}{connected and authenticated openEO client (optional) otherwise \code{\link{active_connection}}
is used.}

\item{...}{additional parameters passed to jsonlite::toJSON() (like 'digits')}
}
\value{
A connection to a file if the parameter 'output_file' was provided otherwise the raw binary data
}
\description{
Executes a job directly on the connected openEO service and returns the data. During the execution phase the connection to 
the server remains open. This function allows to debug the code and check the results immediately. 
Please keep in mind, that computational functions might be related to monetary costs, if no 'free' plan is available. 
Make sure to keep the data selection relatively small, also some openEO service provider might offer limited processes support,
e.g. not supporting UDFs at this endpoint.
}
