% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{OpenEOClient}
\alias{OpenEOClient}
\title{openEO client class}
\description{
An R6Class that interacts with an openEO compliant back-end.
}
\section{Fields}{

\describe{
\item{\code{user_id}}{The user_id obtained after authentication}

\item{\code{api.mapping}}{The mapping of the API endpoints and the back-end published ones}

\item{\code{processes}}{a list of \code{\link{Process}} objects offered by the back-end}
}}

\section{Methods}{

\describe{
  \item{\code{$new(host=NULL)}}{the constructor with an optional host URL to connect to}
  \item{\code{$getBackendEndpoint(endpoint_name)}}{returns the URL for the requested endpoint tag}
  \item{\code{$request(tag,parameters=NULL,authorized=FALSE, ...)}}{performs the desired HTTP request by endpoint tag with 
  path parameters and whether or not authorization (access_token) is necessary}
  \item{\code{$isConnected()}}{whether or not the client has a host set}
  \item{\code{$isLoggedIn()}}{returns a logical describing whether the user is logged in}
  \item{\code{$getHost()}}{returns the host URL}
  \item{\code{$stopIfNotConnected()}}{throws an error if called and the client is not connected}
  \item{\code{$connect(url,version)}}{connects to a specific version of a back-end}
  \item{\code{$api_version()}}{returns the openEO API version this client is compliant to}
  \item{\code{$login(login_type = NULL,user=NULL,password=NULL)}}{creates an \code{\link{IAuth}} object based on the login_type}
  \item{\code{$logout()}}{invalidates the access_token and terminates the current session}
  \item{\code{$getAuthClient()}}{returns the authentication client}
  \item{\code{$setAuthClient(value)}}{sets the authentication client if it was configured and set externally}
  \item{\code{$getCapabilities()}}{service exploration to retrieve the supported openEO endpoints}
  \item{\code{$getDataCollection()}}{returns the list of collections as obtainable at 'list_collections()'}
  \item{\code{$getProcessCollection()}}{returns the evaluated process list as obtainable at 'processes()'}
  \item{\code{$getId()}}{returns the ID of the Connection as stated in the getCapabilities document}
  \item{\code{$getTitle()}}{returns the title of the connection as stated in the getCapabilities document}
}
}

\section{Arguments}{

\describe{
  \item{\code{host}}{the openEO host URL}
  \item{\code{endpoint_name}}{the endpoint tag the client uses for the endpoints}
  \item{\code{tag}}{endpoint tag}
  \item{\code{parameters}}{named list of values to be replaced in the endpoint}
  \item{\code{authorized}}{whether or not the endpoint requires authentication via access_token}
  \item{\code{url}}{url of an openEO back-end either directly versioned or with the separate version statement}
  \item{\code{version}}{the openEO API version to be used, or a list of available API versions if set to NULL}
  \item{\code{user}}{the user name}
  \item{\code{password}}{the user password}
  \item{\code{login_type}}{'basic', 'oidc' or NULL to control the authentication}
  \item{\code{value}}{an authentication object}
}
}

