% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{institutions2df}
\alias{institutions2df}
\title{Convert OpenAlex collection of institutions' records from list format to data frame}
\usage{
institutions2df(data, verbose = TRUE)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{verbose}{Logical. If TRUE, print information on querying process.
Default to \code{verbose = FALSE}.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: <https://docs.openalex.org>
}
\description{
It converts bibliographic collection of institutions' records gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of institutions' records obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Query to search information about all Italian educational institutions

query_inst <- oa_query(
  entity = "institutions",
  country_code = "it",
  type = "education"
)

res <- oa_request(
  query_url = query_inst,
  count_only = FALSE,
  verbose = FALSE
)

oa2df(res, entity = "institutions")
}

# @export
}
