% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_snowball.R
\name{oa_snowball}
\alias{oa_snowball}
\title{A function to perform a snowball search
and convert the result to a tibble/data frame.}
\usage{
oa_snowball(
  identifier = NULL,
  output = c("tibble", "dataframe"),
  mailto = NULL,
  endpoint = "https://api.openalex.org/",
  verbose = FALSE
)
}
\arguments{
\item{identifier}{Character. It indicates a vector of item identifiers.}

\item{output}{a tibble/data.frame.}

\item{mailto}{is a character. To get into the polite pool, the arguments mailto have to give OpenAlex an email where they can contact you.}

\item{endpoint}{is character. It indicates the url of the OpenAlex Endpoint API server. The default value is endpoint = "https://api.openalex.org/".}

\item{verbose}{is a logical. If TRUE, information about the querying process will be plotted on screen. Default is \code{verbose=FALSE}.}
}
\value{
A data.frame or a tibble. Result of the snowball search.
}
\description{
A function to perform a snowball search
and convert the result to a tibble/data frame.
}
\examples{
\dontrun{

snowball_docs <- oa_snowball(
  identifier = c("W2741809807", "W2755950973"),
  endpoint = "https://api.openalex.org/",
  verbose = TRUE
)
}
}
