% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_engine.R
\name{retrieve_engine}
\alias{retrieve_engine}
\title{Retrieve engine}
\usage{
retrieve_engine(
  engine_id,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{engine_id}{required; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain information about the
engine.
}
\description{
Provides information about a specified engine. See \href{https://beta.openai.com/docs/api-reference/engines/retrieve}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/engines/retrieve}{official documentation}.
}
\examples{
\dontrun{
retrieve_engine("text-davinci-002")
}
}
\seealso{
Other engine functions: 
\code{\link{list_engines}()}
}
\concept{engine functions}
