ME_Sent_Token_Annotator <-
function(language = "en", probs = FALSE, model = NULL)
{
    description <- if(is.null(model)) {
        language <- match.arg(language, openNLP_languages)
        package <- if(language == "en")
            "openNLPdata"
        else
            sprintf("openNLPmodels.%s", language)
        model <- system.file("models",
                             sprintf("%s-sent.bin", language),
                             package = package)
        if(model == "") {
            msg <-
                paste(gettextf("Could not find model file for language '%s'.",
                               language),
                      if(system.file(package = package) == "") {
                          gettextf("Please make sure package '%s' is installed,\navailable from http://datacube.wu.ac.at/.",
                                   package)
                      } else {
                          gettextf("Apparently, package '%s' is installed\nbut does not provide this model.",
                                   package)
                      },
                      sep = "\n")
            stop(msg)
        }
        sprintf("Computes sentence annotations using the Apache OpenNLP Maxent sentence detector employing the default model for language '%s'.",
                language)
    }
    else
        "Computes sentence annotations using the Apache OpenNLP Maxent sentence detector employing a user-defined model."

    ## See
    ## http://opennlp.apache.org/documentation/1.5.3/manual/opennlp.html#tools.sentdetect.detection.api

    ref <- .jnew("opennlp.tools.sentdetect.SentenceDetectorME",
                 .jnew("opennlp.tools.sentdetect.SentenceModel",
                       .jcast(.jnew("java.io.FileInputStream", model),
                              "java.io.InputStream")))

    f <- function(x) {
        y <- .jcall(ref,
                    "[Lopennlp/tools/util/Span;",
                    "sentPosDetect",
                    x)
        start <- sapply(y, .jcall, "I", "getStart") + 1L
        end <- sapply(y, .jcall, "I", "getEnd")
        if(probs) {
            probs <- .jcall(ref, "[D", "getSentenceProbabilities")
            Annotation(NULL,
                       rep.int("sentence", length(start)),
                       start,
                       end,
                       .simple_feature_map(probs, "prob"))
        } else 
            Span(start, end)
    }

    Simple_Sent_Token_Annotator(f, description)
}
