/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.DataIndexer;
import opennlp.maxent.DataStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.TwoPassDataIndexer;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.chunker.ChunkerEventStream;
import opennlp.tools.chunker.DefaultChunkerContextGenerator;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.Sequence;

public class ChunkerME
implements Chunker {
    protected BeamSearch beam;
    private Sequence bestSequence;
    protected MaxentModel model;

    public ChunkerME(MaxentModel mod) {
        this(mod, new DefaultChunkerContextGenerator(), 10);
    }

    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg) {
        this(mod, cg, 10);
    }

    public ChunkerME(MaxentModel mod, ChunkerContextGenerator cg, int beamSize) {
        this.beam = new ChunkBeamSearch(beamSize, cg, mod);
        this.model = mod;
    }

    public List chunk(List toks, List tags) {
        this.bestSequence = this.beam.bestSequence(toks, new Object[]{tags.toArray(new String[tags.size()])});
        return this.bestSequence.getOutcomes();
    }

    public String[] chunk(Object[] toks, String[] tags) {
        this.bestSequence = this.beam.bestSequence(Arrays.asList(toks), new Object[]{tags});
        List c = this.bestSequence.getOutcomes();
        return c.toArray(new String[c.size()]);
    }

    protected boolean validOutcome(String outcome, Sequence sequence) {
        return true;
    }

    protected boolean validOutcome(String outcome, String[] sequence) {
        return true;
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    private static GISModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel((int)iterations, (DataIndexer)new TwoPassDataIndexer(es, cut));
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: ChunkerME trainingFile modelFile");
            System.err.println();
            System.err.println("Training file should be one word per line where each line consists of a ");
            System.err.println("space-delimited triple of \"word pos outcome\".  Sentence breaks are indicated by blank lines.");
            System.exit(1);
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        ChunkerEventStream es = new ChunkerEventStream((DataStream)new PlainTextByLineDataStream((Reader)new FileReader(inFile)));
        GISModel mod = args.length > 3 ? ChunkerME.train(es, Integer.parseInt(args[2]), Integer.parseInt(args[3])) : ChunkerME.train(es, 100, 5);
        System.out.println("Saving the model as: " + args[1]);
        new SuffixSensitiveGISModelWriter(mod, outFile).persist();
    }

    class ChunkBeamSearch
    extends BeamSearch {
        public ChunkBeamSearch(int size, ChunkerContextGenerator cg, MaxentModel model) {
            super(size, cg, model);
        }

        protected boolean validSequence(int i, List sequence, Sequence s, String outcome) {
            return ChunkerME.this.validOutcome(outcome, s);
        }

        protected boolean validSequence(int i, Object[] sequence, String[] s, String outcome) {
            return ChunkerME.this.validOutcome(outcome, s);
        }
    }
}

