% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.datasource.r
\name{opal.variables}
\alias{opal.variables}
\title{Get variables of a table}
\usage{
opal.variables(opal, datasource, table, locale = "en", df = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{table}{Name of the table in the datasource.}

\item{locale}{The language for labels (default is "en").}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get variables of a table
}
\examples{
\donttest{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
opal.variables(o, 'datashield', 'CNSIM1')
opal.logout(o)
}
}
\seealso{
Other datasource functions: 
\code{\link{opal.annotate}()},
\code{\link{opal.annotations}()},
\code{\link{opal.attribute_values}()},
\code{\link{opal.datasources}()},
\code{\link{opal.datasource}()},
\code{\link{opal.projects}()},
\code{\link{opal.project}()},
\code{\link{opal.tables}()},
\code{\link{opal.table}()},
\code{\link{opal.valueset}()},
\code{\link{opal.variable}()}
}
\concept{datasource functions}
