% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{individual_results}
\alias{individual_results}
\title{Individual-level PCC and chance values.}
\usage{
individual_results(m, digits)
}
\arguments{
\item{m}{an object of class "opafit" produced by \code{opa()}}

\item{digits}{an integer}
}
\value{
a matrix containing a column of PCC values and a column of c-values
with 1 row per row of data.
}
\description{
Individual-level PCC and chance values.
}
\details{
If the model was fitted with no grouping variable, a matrix of PCCs and
c-values are returned corresponding to the order of rows in the data. If the
\code{opa} model was fitted with a grouping variable specified, a table of
PCCs and c-values is returned ordered by factor level of the grouping
variable.
}
\examples{
dat <- data.frame(t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
opamod <- opa(dat, 1:3)
individual_results(opamod)
}
