% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_functions.R
\name{anat_plot}
\alias{anat_plot}
\title{Plot Picture}
\usage{
anat_plot(picture, anat_layers, plot_stat, color_palette, scale_lim)
}
\arguments{
\item{picture}{grImport object. A vector image imported in R using the 'readPicture' function from grImport.}

\item{anat_layers}{numeric. A named vector with the layer IDs obtained using the 'get_vector_ids_list' function.}

\item{plot_stat}{numeric. A named vector with values corresponding to the branch statistics to be plotted and names matching the names in the layer IDs.}

\item{color_palette}{A character vector or function defining a color palette.}

\item{scale_lim}{numeric. A pair of values defining the lower and upper limits of the scale.}
}
\value{
A plot of the object of class 'Picture' with the assigned colors to different anatomical regions.
}
\description{
Wrapper function for making a plot of an object of class 'Picture' using the 'make_pic' function.
}
\examples{
data("HAO", "hym_graph", "hym_img", "hym_kde")
# Get picture.
picture <- hym_img
# Get picture layers from three anatomical regions.
terms_list <- as.list(c("HAO:0000397", "HAO:0000576", "HAO:0000626"))
terms_list <- setNames(terms_list, c("head", "mesosoma", "metasoma"))
anat_layers <- get_vector_ids_list(terms = terms_list , ONT = HAO, GR = hym_graph)
# Get mean rates all branches for the three anatomical regions.
plot_stat <- lapply(hym_kde, function(x) unlist(lapply(x$loess.lambda.mean, function(x) mean(x) )) )
plot_stat <- do.call(cbind, plot_stat)
# Add two columns for the other anatomical regions (just for this example).
plot_stat <- cbind(plot_stat, plot_stat*0.75, plot_stat*0.5)
colnames(plot_stat) <- c("head", "mesosoma", "metasoma")
# Select an arbitrary branch.
plot_stat <- plot_stat[5,]
# Set scale.
scale_lim <- range(plot_stat)
# Get color palette.
hm.palette <- colorRampPalette(RColorBrewer::brewer.pal(9, "Spectral"), space = "Lab")

# Plot picture.
anat_plot(picture, anat_layers, plot_stat, hm.palette(100), scale_lim)

}
\author{
Diego Porto
}
