% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_format.R
\name{long_format}
\alias{long_format}
\title{Long format of prediction data.frame}
\usage{
long_format(fit, Time = NULL)
}
\arguments{
\item{fit}{The result from either lm_fit or rls_fit}

\item{Time}{If the timestamps are missing from the fit object}
}
\value{
Data.frame of when the prediction where made, also the prediction value and timestamp.
}
\description{
Creates a long format of the predictions
}
\details{
This functions creates a useful prediction data.frame which can be useful for analysis and plotting.
}
\examples{

# Take data
D <- subset(Dbuilding, c("2010-12-15", "2011-01-01"))
D$y <- D$heatload
D$scoreperiod <- in_range("2010-12-20", D$t)
# Define a model
model <- forecastmodel$new()
model$add_inputs(Ta = "Ta",
                 mu = "one()")
model$add_regprm("rls_prm(lambda=0.99)")
model$kseq <- 1:6
# Fit it
fit <- rls_fit(prm=c(lambda=0.99), model, D)

# Get the forecasts (in fit$Yhat) on long format
long_format(fit)

}
