% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.list.R
\name{pairs.data.list}
\alias{pairs.data.list}
\title{Generation of pairs plot for a data.list.}
\usage{
\method{pairs}{data.list}(
  x,
  subset = NA,
  nms = NA,
  kseq = NA,
  lagforecasts = TRUE,
  pattern = NA,
  lower.panel = NULL,
  panel = panel.smooth,
  pch = 20,
  cex = 0.7,
  ...
)
}
\arguments{
\item{x}{The data.list from which to plot.}

\item{subset}{The subset to be included. Passed to \code{\link{subset.data.list}()}.}

\item{nms}{The names of the variables to be included. Passed to \code{\link{subset.data.list}()}.}

\item{kseq}{The horizons to be included. Passed to \code{\link{subset.data.list}()}.}

\item{lagforecasts}{Lag the forecasts such that they are synced with obervations. Passed to \code{\link{subset.data.list}()}.}

\item{pattern}{Regex pattern to select the included variables. Passed to \code{\link{subset.data.list}()}.}

\item{lower.panel}{Passed to \code{\link{pairs}()}.}

\item{panel}{Passed to \code{\link{pairs}()}.}

\item{pch}{Passed to \code{\link{pairs}()}.}

\item{cex}{Passed to \code{\link{pairs}()}.}

\item{...}{Passed to \code{\link{pairs}()}.}
}
\description{
Generate a pairs plot for the vectors in the data.list.
}
\details{
A very useful plot for checking what is in the forecasts, how they are synced and match the observations.
}
\examples{
# Take a subset for the example
D <- subset(Dbuilding, c("2010-12-15","2011-01-15"), pattern="^Ta|^I", kseq=1:3)
pairs(D)

# If the forecasts and the observations are not aligned in time,
# which is easy to see by comparing to the previous plot.
pairs(D, lagforecasts=FALSE)
# Especially for the solar I syncronization is really important!
# Hence if the forecasts were not synced properly, then it can be detected using this type of plot.

# Alternatively, lag when taking the subset
D <- subset(Dbuilding, c("2010-12-15","2011-01-15"), pattern="^Ta|^I", kseq=1:3, lagforecasts=TRUE)
pairs(D, lagforecasts=FALSE)

}
