% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onetime.R
\name{onetime_only}
\alias{onetime_only}
\title{Wrap a function to be called only once}
\usage{
onetime_only(
  .f,
  id = calling_package(),
  path = default_lockfile_dir(),
  without_permission = "warn"
)
}
\arguments{
\item{.f}{A function}

\item{id}{Unique ID string. By default, name of the calling package.}

\item{path}{Directory to store lockfiles.}

\item{without_permission}{Character string. What to do if the user hasn't
given permission to store files? \code{"warn"} runs the action with an extra
warning; \code{"run"} runs the action; \code{"pass"} does nothing and returns the
default; \code{"stop"} throws an error; \code{"ask"} asks for permission, after
running the action but before recording it on disk.}
}
\value{
A wrapped function.
}
\description{
This takes a function and returns the same function wrapped by \code{\link[=onetime_do]{onetime_do()}}.
Use it for code which should run only once, but which may be called from
multiple locations. This frees you from having to use the same \code{id} multiple
times.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1)

sample_once <- onetime_only(sample, id = id)
sample_once(1:10)
sample_once(1:10)

onetime_reset(id)
options(oo)
}
\seealso{
\code{\link[=onetime_do]{onetime_do()}}
}
