% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlang.R
\name{onetime-rlang}
\alias{onetime-rlang}
\alias{onetime_rlang_warn}
\alias{onetime_rlang_inform}
\title{Print a warning or message only once using \code{rlang} functions}
\usage{
onetime_rlang_warn(
  ...,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  without_permission = "warn"
)

onetime_rlang_inform(
  ...,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  without_permission = "warn"
)
}
\arguments{
\item{...}{Passed to \code{\link[rlang:abort]{rlang::warn()}} or \code{\link[rlang:abort]{rlang::inform()}}.}

\item{id}{Unique ID string. By default, name of the calling package.}

\item{path}{Directory to store lockfiles.}

\item{expiry}{\code{\link[=difftime]{difftime()}} or e.g. \code{\link[lubridate:duration]{lubridate::duration()}} object.
After this length of time, code will be run again.}

\item{without_permission}{Character string. What to do if the user hasn't
given permission to store files? \code{"warn"} runs the action with an extra
warning; \code{"run"} runs the action; \code{"pass"} does nothing and returns the
default; \code{"stop"} throws an error; \code{"ask"} asks for permission, after
running the action but before recording it on disk.}
}
\value{
\code{TRUE} if the message/warning was shown, \code{FALSE} otherwise.
}
\description{
If you use these you will need to add \code{"rlang"} to your package dependencies.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1)

for (n in 1:3) {
  onetime_rlang_warn(c("rlang-style warning", i = "Extra info"), id = id)
}

onetime_reset(id = id)
options(oo)
}
