% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_segregation.R
\name{select_segreg}
\alias{select_segreg}
\title{Show markers with/without segregation distortion}
\usage{
select_segreg(x, distorted = FALSE, numbers = FALSE,
  threshold = NULL)
}
\arguments{
\item{x}{an object of class onemap_segreg_test}

\item{distorted}{a TRUE/FALSE variable to show distorted or non-distorted markers}

\item{numbers}{a TRUE/FALSE variable to show the numbers or the names of the markers}

\item{threshold}{a number between 0 and 1 to specify the threshold to be considered in the test. If NULL, it uses the threshold defined by bonferroni correction with alpha = 0.05}
}
\value{
a vector with marker names or numbers, according to the option for "distorted" and "numbers"
}
\description{
A function to shows which marker have segregation distortion if Bonferroni's correction is
applied for the Chi-square tests of mendelian segregation.
}
\examples{
# Loads a fake backcross dataset installed with onemap
data(onemap_example_bc)
# Performs the chi-square test for all markers
Chi <- test_segregation(onemap_example_bc)
# To show non-distorted markers
select_segreg(Chi)
# To show markers with segregation distortion
select_segreg(Chi, distorted=TRUE)
# To show the numbers of the markers with segregation distortion
select_segreg(Chi, distorted=TRUE, numbers=TRUE)

}
