% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_table.R
\name{build_span}
\alias{build_span}
\title{Construct Table Span From Components}
\usage{
build_span(
  table_body = NULL,
  row_common = NULL,
  table_body_head = NULL,
  row_common_head = NULL,
  header_format = "text",
  obnd = NULL,
  row_sel = NULL,
  col_sel = NULL,
  table_alignment = "center",
  inner_border = officer::fp_border(color = "black", width = 0.3),
  outer_border = officer::fp_border(color = "black", width = 2),
  set_header_inner_border_v = TRUE,
  set_header_inner_border_h = TRUE,
  set_header_outer_border = TRUE,
  set_body_inner_border_v = TRUE,
  set_body_inner_border_h = FALSE,
  set_body_outer_border = TRUE,
  notes_detect = NULL
)
}
\arguments{
\item{table_body}{Data frame with the body of the large table.}

\item{row_common}{Data frame with the common rows.}

\item{table_body_head}{Data frame or matrix with headers for the table body.}

\item{row_common_head}{Data frame or matrix with headers for the common rows.}

\item{header_format}{Format of the header either \code{"text"} (default) or \code{"md"} for markdown.}

\item{obnd}{Optional onbrand object used to format markdown. The default \code{NULL} value will use default formatting.}

\item{row_sel}{Indices of rows to build to the table with.}

\item{col_sel}{Indices of columns to build to the table with.}

\item{table_alignment}{Character string specifying the alignment #'of the table (body and headers). Can be \code{"center"} (default), \code{"left"}, \code{"right"}, or \code{"justify"}}

\item{inner_border}{Border object for inner border lines defined using \code{officer::fp_border()}}

\item{outer_border}{Border object for outer border lines defined using \code{officer::fp_border()}}

\item{set_header_inner_border_v}{Boolean value to enable or disable inner vertical borders for headers}

\item{set_header_inner_border_h}{Boolean value to enable or disable inner horizontal borders for headers}

\item{set_header_outer_border}{Boolean value to enable or disable outer border for headers}

\item{set_body_inner_border_v}{Boolean value to enable or disable inner vertical borders for the body}

\item{set_body_inner_border_h}{Boolean value to enable or disable inner horizontal borders for the body}

\item{set_body_outer_border}{Boolean value to enable or disable outer border borders for the body}

\item{notes_detect}{Vector of strings to detect in output tables (example \code{c("NC", "BLQ")}).}
}
\value{
list with the following elements
\itemize{
  \item{df:}     Data frame with the built table.
  \item{ft:}     The data frame as a flextable object.
  \item{notes:}  Note placeholders found in the table.
}
}
\description{
Takes a large table, common rows, and header information and
constructs a table that is a subset of those components using supplied
ranges of rows and columns.
}
\details{
The way the data frames relate to each other are mapped out below. The
dimensions of the different data frames are identified below (nrow x ncol)


\preformatted{
                            col_sel
                      |<--------------->|

|--------------------------------------------| ---
|                 |   .                 .    |  ^
|                 |   .                 .    |  |
| row_common_head |   . table_body_head .    |  | m
|      m x n      |   .      m x c      .    |  |
|                 |   .                 .    |  v
|--------------------------------------------| ---
|                 |   .                 .    |  ^
|                 |   .                 .    |  |
|    row_common   |   .   table_body    .    |  |
|      r x n      |   .     r x c       .    |  |
|                 |   .                 .    |  |
|.................|..........................|  |     -
|                 |   ./  /  /  /  /  / .    |  |     ^
|                 |   .  /  /  /  /  /  .    |  | r   |
|                 |   . /  /  /  /  /  /.    |  |     | row_sel
|                 |   ./  /  /  /  /  / .    |  |     |
|                 |   .  /  /  /  /  /  .    |  |     v
|.................|...../../../../../../.... |  |     -
|                 |   .                 .    |  |
|                 |   .                 .    |  v
|--------------------------------------------| ---

|<--------------->|<------------------------>|
        n                    c
}
}
\examples{
if(interactive()){
trow = c(1:51)
tcol = c(1:63)
cht  = c(rep("A", 20),
         rep("B", 20),
         rep("C", 11))


table_body = NULL
for(cn in tcol){
  if(is.null(table_body)){
    tmp_cmd =  paste0("table_body = data.frame(C_",
                      cn,"= paste0(trow, ',', cn))")
  } else {
    tmp_cmd =  paste0("table_body = cbind(table_body, data.frame(C_",
                      cn,"= paste0(trow, ',', cn)))")
  }
  eval(parse(text=tmp_cmd))
}


table_body[1,]    = "BQL"
table_body[5,8]   = "NC"
table_body[20,]   = "BQL"
table_body[25,2]  = "NC"

row_common = data.frame(
    ID = trow,
    CH = cht)


row_common_head = data.frame(
    ID  = c("ID",     "ID", "ID"),
    CH  = c("Cohort", "Cohort", "Cohort"))



table_body_head = NULL

cidx = 1
for(cn in names(table_body)){

  units = "units"
  range = "range"

  if(cidx < 4){
    range = "R A"
  } else if(cidx < 12 ){
    range = "R B"
  } else if(cidx < 18 ){
    range = "R C"
  } else if(cidx < 28 ){
    range = "R D"
  } else if(cidx < 35 ){
    range = "R E"
  } else if(cidx < 48 ){
    range = "R F"
  } else if(cidx < 55 ){
    range = "R G"
  } else if(cidx < 60 ){
    range = "R H"
  } else {
    range = "R I"
  }

  if(cidx < 4){
    units = "U A"
  } else if(cidx < 8  ){
    units = "U B"
  } else if(cidx < 14 ){
    units = "U Q"
  } else if(cidx < 18 ){
    units = "U C"
  } else if(cidx < 28 ){
    units = "U D"
  } else if(cidx < 35 ){
    units = "U E"
  } else if(cidx < 48 ){
    units = "U F"
  } else if(cidx < 55 ){
    units = "U G"
  } else if(cidx < 60 ){
    units = "U H"
  } else {
    units = "U I"
  }

  if(is.null(table_body_head)){
    tmp_cmd =  paste0("table_body_head = data.frame(",
                      cn,'= c("', cn, '", units, range))')
  } else {
    tmp_cmd =  paste0("table_body_head = cbind(table_body_head, data.frame(",
                      cn,'= c("', cn, '", units, range)))')
  }

  eval(parse(text=tmp_cmd))
  cidx = cidx + 1
}

res =
span_table(table_body      = table_body,
           row_common      = row_common,
           table_body_head = table_body_head,
           row_common_head = row_common_head,
           max_row         = 20,
           max_col         = 10,
           notes_detect    = c("BQL", "NC"))

# Notes detected in the first table:
res[["tables"]][["Table 1"]][["notes"]]

# First table as a data frame:
res[["tables"]][["Table 1"]][["df"]]

# First table as a flextable:
res[["tables"]][["Table 1"]][["ft"]]

}

}
