% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{write_lookup}
\alias{write_lookup}
\title{Function to write a lookup vector to an OMX file}
\usage{
write_lookup(
  file,
  lookup_v,
  name,
  lookup_dim = NULL,
  replace = FALSE,
  description = ""
)
}
\arguments{
\item{file}{Full path name of the OMX file to store the lookup.}

\item{lookup_v}{Vector containing the lookup information. Should be the same
length as the matrix dimension it maps to (see \code{lookup_dim})}

\item{name}{Name for the lookup vector in \code{file}.}

\item{lookup_dim}{Matrix dimension that the lookup vector is associated with
Values can be "row", "col", or NULL, meaning that the lookup is
two-dimensional. Defaults to \code{NULL}.}

\item{replace}{Overwrite the existing lookup (if any)? Defaults to
\code{FALSE}.}

\item{description}{String defining the lookup.}
}
\value{
None
}
\description{
This function writes a lookup vector to the file. It allows the user to
specify if the lookup vector applies only to rows or columns (in case the
matrix is not square and/or the rows and columns don't have the same
meanings.
}
\examples{
# create a test file
omxfile <- tempfile(fileext = ".omx")
create_omx(omxfile, 25, 25)
EI <- c(rep("Int", 21), rep("Ext", 4))
D <-  rep(1:5, each = 5)
write_lookup(omxfile, EI, "EI", description = "External and Internal Zones")
write_lookup(omxfile, D, "Districts", description = "Districts")

}
