% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validateNameStyle}
\alias{validateNameStyle}
\title{Validate \code{nameStyle} argument. If any of the element in \code{...} has length
greater than 1 it must be contained in nameStyle. Note that snake case
notation is used.}
\usage{
validateNameStyle(nameStyle, ..., call = parent.frame())
}
\arguments{
\item{nameStyle}{A character vector. It must contain all the \code{...} elements
in snake_case format and between \code{{}}.}

\item{...}{Elements to be included.}

\item{call}{Passed to cli functions.}
}
\value{
invisible nameStyle.
}
\description{
Validate \code{nameStyle} argument. If any of the element in \code{...} has length
greater than 1 it must be contained in nameStyle. Note that snake case
notation is used.
}
\examples{
validateNameStyle(
  nameStyle = "hi_{cohort_name}",
  cohortName = c("cohort1", "cohort2"),
  otherVariable = c("only 1 value")
)

\dontrun{
validateNameStyle(
  nameStyle = "hi_{cohort_name}",
  cohortName = c("cohort1", "cohort2"),
  otherVariable = c("value1", "value2")
)
}
validateNameStyle(
  nameStyle = "{other_variable}_hi_{cohort_name}",
  cohortName = c("cohort1", "cohort2"),
  otherVariable = c("value1", "value2")
)

}
