% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-forward-regression.R
\name{ols_step_forward_sbic}
\alias{ols_step_forward_sbic}
\alias{ols_step_forward_sbic.default}
\alias{plot.ols_step_forward_sbic}
\title{Stepwise SBIC forward regression}
\usage{
ols_step_forward_sbic(model, ...)

\method{ols_step_forward_sbic}{default}(
  model,
  include = NULL,
  exclude = NULL,
  progress = FALSE,
  details = FALSE,
  ...
)

\method{plot}{ols_step_forward_sbic}(x, print_plot = TRUE, details = TRUE, digits = 3, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other arguments.}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_forward_*}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{digits}{Number of decimal places to display.}
}
\value{
List containing the following components:

\item{model}{final model; an object of class \code{lm}}
\item{metrics}{selection metrics}
\item{others}{list; info used for plotting and printing}
}
\description{
Build regression model from a set of candidate predictor variables by
entering predictors based on sawa bayesian criterion, in a stepwise
manner until there is no variable left to enter any more.
}
\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_step_forward_sbic(model)

# stepwise forward regression plot
k <- ols_step_forward_sbic(model)
plot(k)

# selection metrics
k$metrics

# extract final model
k$model

# include or exclude variables
# force variable to be included in selection process
ols_step_forward_sbic(model, include = c("age"))

# use index of variable instead of name
ols_step_forward_sbic(model, include = c(5))

# force variable to be excluded from selection process
ols_step_forward_sbic(model, exclude = c("liver_test"))

# use index of variable instead of name
ols_step_forward_sbic(model, exclude = c(4))

# include & exclude variables in the selection process
ols_step_forward_sbic(model, include = c("age"), exclude = c("liver_test"))

# use index of variable instead of name
ols_step_forward_sbic(model, include = c(5), exclude = c(4))

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other forward selection procedures: 
\code{\link{ols_step_forward_adj_r2}()},
\code{\link{ols_step_forward_aic}()},
\code{\link{ols_step_forward_p}()},
\code{\link{ols_step_forward_r2}()},
\code{\link{ols_step_forward_sbc}()}
}
\concept{forward selection procedures}
