% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-backward-regression.R
\name{ols_stepaic_backward}
\alias{ols_stepaic_backward}
\alias{plot.ols_stepaic_backward}
\title{Stepwise AIC Backward Regression}
\usage{
ols_stepaic_backward(model, ...)

\method{plot}{ols_stepaic_backward}(x, ...)
}
\arguments{
\item{model}{an object of class \code{lm}; the model should include all candidate predictor variables}

\item{...}{other arguments}

\item{x}{an object of class \code{ols_stepaic_backward}}
}
\value{
\code{ols_stepaic_backward} returns an object of class \code{"ols_stepaic_backward"}.
An object of class \code{"ols_stepaic_backward"} is a list containing the
following components:

\item{steps}{f statistic}
\item{predictors}{p value of \code{score}}
\item{aics}{degrees of freedom}
\item{ess}{fitted values of the regression model}
\item{rss}{name of explanatory variables of fitted regression model}
\item{rsq}{response variable}
\item{arsq}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by removing predictors based on 
Akaike Information Criteria, in a stepwise manner until there is no variable left to remove any more.
}
\examples{
# stepwise backward regression
model <- lm(y ~ ., data = surgical)
ols_stepaic_backward(model)

# stepwise backward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_stepaic_backward(model)
plot(k)

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}

