% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapers.R
\name{get_galleys_from_article}
\alias{get_galleys_from_article}
\title{Scraps an OJS article for galley links}
\usage{
get_galleys_from_article(input_url, verbose = FALSE)
}
\arguments{
\item{input_url}{Character vector.}

\item{verbose}{Logical.}
}
\value{
A long-format dataframe with the url you provided (input_url), the articles url scrapped (output_url),
the format of the galley (format), and the url that forces download of the galley (download_url)
}
\description{
Takes a vector of OJS urls and scraps them to retrieve links to OJS galleys
}
\examples{
\donttest{
articles <- c(
  'https://revistapsicologia.uchile.cl/index.php/RDP/article/view/55657',
  'https://dspace.palermo.edu/ojs/index.php/psicodebate/article/view/516/311'
)
galleys <- ojsr::get_galleys_from_article(input_url = articles,verbose = TRUE)
}
}
