% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_informations.R
\name{annotate_base}
\alias{annotate_base}
\title{PowerPoint placeholder parameters annotation}
\usage{
annotate_base(path = NULL, output_file = "annotated_layout.pptx")
}
\arguments{
\item{path}{path to the pptx file to use as base document or NULL to use the officer default}

\item{output_file}{filename to store the annotated powerpoint file or NULL to suppress generation}
}
\value{
rpptx object of the annotated PowerPoint file
}
\description{
generates a slide from each layout in the base document to
identify the placeholder indexes, types, names, master names and layout names.

This is to be used when need to know what parameters should be used with
\code{ph_location*} calls. The parameters are printed in their corresponding shapes.

Note that if there are duplicated \code{ph_label}, you should not use \code{ph_location_label}.
}
\examples{
# To generate an anotation of the default base document with officer:
annotate_base(output_file = tempfile(fileext = ".pptx"))

# To generate an annotation of the base document 'mydoc.pptx' and place the
# annotated output in 'mydoc_annotate.pptx'
# annotate_base(path = 'mydoc.pptx', output_file='mydoc_annotate.pptx')

}
\seealso{
Other functions for reading presentation informations: \code{\link{color_scheme}},
  \code{\link{layout_properties}},
  \code{\link{layout_summary}}, \code{\link{length.rpptx}},
  \code{\link{slide_size}}, \code{\link{slide_summary}}
}
\concept{functions for reading presentation informations}
