% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oenb_data.R
\name{oenb_data}
\alias{oenb_data}
\title{Download OeNB Data}
\usage{
oenb_data(
  id,
  pos,
  freq = NULL,
  attr = NULL,
  starttime = NULL,
  endtime = NULL,
  lang = "EN"
)
}
\arguments{
\item{id}{character specifying the ID of the dataset of interest.
See \code{\link{oenb_toc}} to obtain the required ID.}

\item{pos}{character vector specifying the position IDs of the indicators of interest.
See \code{\link{oenb_dataset}} to obtain the required ID.}

\item{freq}{Frequency of the data. Where available, possible values are
\code{"D"}, \code{"M"}, \code{"Q"}, \code{"H"}, \code{"A"}
for daily, monthly, quarterly, semi-annual and annual data.
See \code{\link{oenb_frequency}} to obtain possible choices.}

\item{attr}{A named vector of further attributes.
See \code{\link{oenb_attributes}} to obtain possible choices.}

\item{starttime}{character specifying the start of the series. See 'Details'.}

\item{endtime}{character specifying the end of the series. See 'Details'.}

\item{lang}{Preferred language of the output. Possible values are "DE" for
German and "EN" for English (default).}
}
\value{
A data frame.
}
\description{
Download data sets from the OeNB's data web service \url{https://www.oenb.at/en/Statistics/User-Defined-Tables/webservice.html}.
}
\details{
The arguments `starttime` and `endtime` can have the format `YYYY-MM-DD` or
`YYYYMMDD` for daily data, `YYYY-MM` or `YYYYMM` for monthly data, and `YYYY` for
annual data. For semiannual data `YYYY-06` refers to the first half of year `YYYY` and
`YYYY-12` to the second. Similarly, for quarterly data `YYYY-03`, `YYYY-06`, `YYYY-09`
and `YYYY-12` refer to the first, second, third and forth quarter of year `YYYY`,
respectively.
}
\examples{
\donttest{
series <- oenb_data(id = "11", pos = "VDBFKBSC217000", freq = "M", attr = c("dval1" = "AT"),
                    starttime = "2019-11", endtime = "2019-12")
series
}

}
