% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata}
\alias{getdata}
\title{Downloads and processes the data from the API}
\usage{
getdata(origin, dest, year, classification)
}
\arguments{
\item{origin}{Country code of origin (e.g. "chl" for Chile)}

\item{dest}{Country code of destination (e.g. "chn" for China)}

\item{year}{The OEC's API ranges from 1962 to 2016}

\item{classification}{Trade classification that can be "1" (HS92 4 characters since year 1995), "2" (SITC rev.2 4 characters since year 1962) or "3" (HS92 6 characters since year 1995)}
}
\description{
Downloads and processes the data from the API
}
\examples{
# Run countries_list() to display the full list of countries
# For the example Chile is "chl" and China is "chn"

# Download trade between Chile and China
# Year 2016 (HS92 4 characters)
# getdata("chl", "chn", 2016)
# getdata("chl", "chn", 2016, 1) # equivalent to last command

# Download trade between Chile and China
# Year 2016 (SITC rev2 4 characters)
# getdata("chl", "chn", 2016, 2)

# Download trade between Chile and China
# Year 2016 (HS92 6 characters)
# getdata("chl", "chn", 2016, 3)
}
\keyword{functions}
