% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.compare.R
\name{network.compare}
\alias{network.compare}
\title{Creates a network that compares the exporting opportunities of a country in two different years.}
\usage{
network.compare(ORIGIN, DESTINATION, CLASSIFICATION, YEAR1, YEAR2)
}
\arguments{
\item{ORIGIN}{is the country code of origin (e.g. "chl" for Chile)}

\item{DESTINATION}{is the country code of origin (e.g. "chn" for China)}

\item{CLASSIFICATION}{refers to the trade classification that can be "6" (HS92 6 characters) or "8" (HS92 8 characters) for the year 1995 and going or "4" (SITC rev.2 4 characters) for the year 1962 and ongoing}

\item{YEAR1}{is the initial year and the OEC's API ranges from 1962 to 2014}

\item{YEAR2}{is the final year and the OEC's API ranges from 1962 to 2014}
}
\value{
Creates an \code{HTML} file in the working directory with a tree map visualization.
}
\description{
Creates a network that compares the exporting opportunities of a country in two different years.
}
\examples{
network.compare("chl", "chn", 6, 2000, 2010)
}
\keyword{functions}

