% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\name{read.topo}
\alias{read.topo}
\title{Read a Topo File}
\usage{
read.topo(file, encoding = "latin1", debug = getOption("oceDebug"))
}
\arguments{
\item{file}{Name of a file containing an ETOPO-format dataset. Three
types are permitted; see \dQuote{Details}.}

\item{encoding}{ignored.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A \linkS4class{topo} object.
}
\description{
Read a file that contains topographic data in the ETOPO dataset, as was once provided by
the NOAA website (see \code{\link[=download.topo]{download.topo()}} for a good server for such
files. (As of May, 2020, there does not seem to be a way to download these
files from the NOAA website.)
}
\details{
The three permitted file types are as follows.
\enumerate{
\item An ascii type
in which line 1 holds a label (which is ignored), whitespace, and then
the number of columns in the matrix (i.e. the number of longitude values),
line 2 is similar but for latitude, line 3 is similar but for the westernmost
longitude, line 4 is similar but for southernmost latitude, line 5
is similar but for cell size, and lines after that hold the grid.
\item A NetCDF format that was once described by NOAA as "GMT NetCDF".
\item A NetCDF format that was once described by NOAA as "NetCDF".
}
}
\examples{
\dontrun{
library(oce)
topoMaritimes <- read.topo("topoMaritimes.asc")
plot(topographyMaritimes)
}

}
\seealso{
Other things related to topo data: 
\code{\link{[[,topo-method}},
\code{\link{[[<-,topo-method}},
\code{\link{as.topo}()},
\code{\link{download.topo}()},
\code{\link{plot,topo-method}},
\code{\link{subset,topo-method}},
\code{\link{summary,topo-method}},
\code{\link{topo-class}},
\code{\link{topoInterpolate}()},
\code{\link{topoWorld}}
}
\author{
Dan Kelley
}
\concept{things related to topo data}
