% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\name{read.topo}
\alias{read.topo}
\title{Read a Topo File}
\usage{
read.topo(file, debug = getOption("oceDebug"))
}
\arguments{
\item{file}{Name of a file containing an ETOPO-format dataset. Three
types are permitted; see \dQuote{Details}.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A \linkS4class{topo} object that.
}
\description{
Read a file that contains topographic data in the ETOPO dataset, as provided by
the NOAA website (see \code{\link[=download.topo]{download.topo()}} for a good server for such
files.
}
\details{
The three permitted file types are as follows: (1) an ascii type described
by NOAA as "?"; (2) a NetCDF format described by NOAA as "GMT NetCDF"
(recognized by the presence of a variable named \verb{), and (3) another NetCDF format described by NOAA as "NetCDF" (recognized by the presence of a variable called }). Files in each of these formats
can be downloaded with \code{\link[=download.topo]{download.topo()}}.
}
\examples{
\dontrun{
library(oce)
topoMaritimes <- read.topo("topoMaritimes.asc")
plot(topographyMaritimes)
}

}
\seealso{
Other things related to topo data: 
\code{\link{[[,topo-method}},
\code{\link{[[<-,topo-method}},
\code{\link{as.topo}()},
\code{\link{download.topo}()},
\code{\link{plot,topo-method}},
\code{\link{subset,topo-method}},
\code{\link{summary,topo-method}},
\code{\link{topo-class}},
\code{\link{topoInterpolate}()},
\code{\link{topoWorld}}
}
\author{
Dan Kelley
}
\concept{things related to topo data}
